#!/bin/bash

#Some cleanup
rm -rf install petsc-2.3.2-p3 src
mkdir install src

#Untar and move petsc to install directory
tar -zxvf  petsc-2.3.2-p3.tar.gz
mv petsc-2.3.2-p3/* install/
rm -rf petsc-2.3.2-p3

#configure
cd install
./config/configure.py  --prefix="$ISSM_TIER/externalpackages/petsc/install" \
	--with-mpi-dir=$ISSM_TIER/externalpackages/mpich2/install \
	--PETSC_ARCH=macosx-gnu \
	--PETSC_DIR="$ISSM_TIER/externalpackages/petsc/install" \
	--with-fc=/usr/local/bin/gfortran \
	--with-debugging=0 \
	--with-shared=0 \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-blas=yes \
	--download-f-blas-lapack=yes \
	--FFLAGS="-I$ISSM_TIER/externalpackages/mpich2/install/include -L$ISSM_TIER/externalpackages/mpich2/install/lib -L/usr/local/bin -lmpich -lpmpich -lgfortran" \
	--download-plapack=yes

#Compile petsc and install it
make -j $1
make install
