#!/bin/bash

#Some cleanup
rm -rf install petsc-2.3.2-p3 src
mkdir install src

#Untar and move petsc to install directory
tar -zxvf  petsc-2.3.2-p3.tar.gz
mv petsc-2.3.2-p3/* install/
rm -rf petsc-2.3.2-p3

#configure
cd install
./config/configure.py  \
	--prefix="$ISSM_TIER/externalpackages/petsc/install" \
	--with-mpi-dir=$ISSM_TIER/externalpackages/mpich2/install \
	--PETSC_ARCH=linux-gnu-amd64 \
	--PETSC_DIR="$ISSM_TIER/externalpackages/petsc/install" \
	--with-fc=gfortran \
	--with-debugging=1 \
	--with-shared=0 \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-blas=yes \
	--download-f-blas-lapack=yes \
	--FFLAGS=-I$ISSM_TIER/externalpackages/mpich2/install/include \
	--download-plapack=yes \
	--COPTFLAGS="-march=opteron -O2" \
	--FOPTFLAGS="-march=opteron -O2" \
	--CXXOPTFLAGS="-march=opteron -O2" 

#Compile petsc and install it
make -j $1
make install
