#!/bin/bash

#Some cleanup
rm -rf src install mpich2-1.4
mkdir src install

#Untar 
tar -zxvf  mpich2-1.4.tar.gz

#Move mpich2 into src directory
mv mpich2-1.4/* src
rm -rf mpich2-1.4

#Configure mpich2
cd src
export FCFLAGS=" -m64"
export FFLAGS=" -m64"
export CFLAGS=" -arch x86_64"
export CXXFLAGS=" -arch x86_64"
./configure \
	--prefix="$ISSM_TIER/externalpackages/mpich2/install" \
	--enable-f91 \
	--enable-sharedlibs=osx-gcc \
	--enable-shared \
	--enable-fc

#Compile mpich2
make -j $1
make install 

#remove so files
cd ../install/lib
rm -rf *.so
