#!/bin/bash

#Erase install
rm -rf source build install

#Download code
hg clone http://mercurial.mcs.anl.gov/ad/ADIC -r 631 source

#Then update to -r 631
cd source 
hg update -r 631

#Configure and Compile
cd source
./autogen.sh
./aclocal
cd ..
mkdir build
cd build
../source/configure \
	--with-rose=$ISSM_TIER/externalpackages/rose/install \
	--with-openanalysis=$ISSM_TIER/externalpackages/openanalysis/openanalysis/x86_64-Linux \
	--with-boost=$ISSM_TIER/externalpackages/boost/install \
	--with-xerces=$ISSM_TIER/externalpackages/xerces/src \
	--with-xaifbooster=$ISSM_TIER/externalpackages/xaifbooster/xaifBooster \
	--with-colpack=$ISSM_TIER/externalpackages/colpack/install\
	--prefix=$ISSM_TIER/externalpackages/adic/install 
make -j $1
make -j $1 install
