%Create model
md=model;

%Create mesh
L=100000; %in m
nx=20; %numberof nodes in x direction
ny=20;
md=squaremesh(md,L,L,nx,ny);

md=setmask(md,'',''); %ice sheet test
md=parameterize(md,'./test2.par');
md=extrude(md,5,1);
md=setflowequation(md,'pattyn','all');

%Boundary conditions
md.diagnostic.spcvx(:)=NaN;
md.diagnostic.spcvy(:)=NaN;
md.diagnostic.spcvz(:)=NaN;
%Create dirichlet on the bed if no slip
pos=find(md.mesh.vertexonbed);
md.diagnostic.spcvx(pos)=0;
md.diagnostic.spcvy(pos)=0;
md.diagnostic.spcvz(pos)=0;

%Create MPCs to have periodic boundary conditions
posx=find(md.mesh.x==0);
posx2=find(md.mesh.x==max(md.mesh.x));
posy=find(md.mesh.y==0); %Don't take the same grids two times
posy2=find(md.mesh.y==max(md.mesh.y));
md.diagnostic.vertex_pairing=[posx,posx2;posy,posy2];
md.prognostic.vertex_pairing=[posx,posx2;posy,posy2];

%Transient parameters
md.timestepping.time_step=4;
md.timestepping.final_time=4*20;
md.transient.isthermal=0;

%Compute the diagnostic
md.cluster=generic('name',oshostname(),'np',2);
md.verbose=verbose('convergence',true,'solution',true);
md=solve(md,TransientSolutionEnum);
