/*
 * CreateElementsNodesAndMaterialsDiagnosticHutter.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateElementsNodesAndMaterialsDiagnosticHutter"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../Model.h"


void	CreateElementsNodesAndMaterialsDiagnosticHutter(DataSet** pelements,DataSet** pnodes, DataSet** pmaterials, Model* model,ConstDataHandle model_handle){


	int i,k;
	extern int my_rank;
	extern int num_procs;

	/*DataSets: */
	DataSet*    elements  = NULL;
	DataSet*    nodes = NULL;
	DataSet*    materials = NULL;
	
	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum());
	nodes     = new DataSet(NodesEnum());
	materials = new DataSet(MaterialsEnum());

	/*Objects: */
	Node*       node   = NULL;
	Matice*     matice = NULL;
	Matpar*     matpar = NULL;
	Beam*       beam   = NULL;
	Sing*       sing   = NULL;

	int         analysis_type;
	int         sub_analysis_type;
	
	/*output: */
	int* epart=NULL; //element partitioning.
	int* npart=NULL; //node partitioning.
	int* my_grids=NULL;
	double* my_bordergrids=NULL;

	/*intermediary: */
	int elements_width; //size of elements
	double B_avg;
			
	/*matice constructor input: */
	int    matice_mid;
	double matice_B;
	double matice_n;

	/*sing constructor input: */
	int   sing_id;
	int   sing_mid;
	int   sing_mparid;
	int   sing_g;
	double sing_h,sing_k;

	/*beam constructor input: */
	int   beam_id;
	int   beam_mid;
	int   beam_mparid;
	int   beam_g[2];
	double beam_h[2];
	double beam_s[2];
	double beam_b[2];
	double beam_k[2];
	bool    beam_onbed;
					
	/*matpar constructor input: */
	int	matpar_mid;
	double matpar_rho_ice; 
	double matpar_rho_water;
	double matpar_heatcapacity;
	double matpar_thermalconductivity;
	double matpar_latentheat;
	double matpar_beta;
	double matpar_meltingpoint;
	double matpar_mixed_layer_capacity;
	double matpar_thermal_exchange_velocity;
	double matpar_g;

	/* node constructor input: */
	int node_id;
	int node_partitionborder=0;
	double node_x[3];
	double node_sigma;
	int node_onbed;
	int node_onsurface;
	int node_onshelf;
	int node_onsheet;
	int node_upper_node_id;
	int node_numdofs;

	#ifdef _PARALLEL_
	/*Metis partitioning: */
	int  range;
	Vec  gridborder=NULL;
	int  my_numgrids;
	int* all_numgrids=NULL;
	int  gridcount;
	int  count;
	#endif

	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum());
	nodes     = new DataSet(NodesEnum());
	materials = new DataSet(MaterialsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!model->ishutter)goto cleanup_and_return;

	/*Get analysis_type: */
	analysis_type=AnalysisTypeAsEnum(model->analysis_type);
	sub_analysis_type=AnalysisTypeAsEnum(model->sub_analysis_type);

	/*Width of elements: */
	if(strcmp(model->meshtype,"2d")==0){
		elements_width=3; //tria elements
	}
	else{
		elements_width=6; //penta elements
	}

	#ifdef _PARALLEL_
	/*Determine parallel partitioning of elements: we use Metis for now. First load the data, then partition*/
	if(strcmp(model->meshtype,"2d")==0){
		/*load elements: */
		ModelFetchData((void**)&model->elements,NULL,NULL,model_handle,"elements","Matrix","Mat");
	}
	else{
		/*load elements2d: */
		ModelFetchData((void**)&model->elements2d,NULL,NULL,model_handle,"elements2d","Matrix","Mat");
	}

	MeshPartitionx(&epart, &npart,model->numberofelements,model->numberofnodes,model->elements, model->numberofelements2d,model->numberofnodes2d,model->elements2d,model->numlayers,elements_width, model->meshtype,num_procs);

	/*Free elements and elements2d: */
	xfree((void**)&model->elements);
	xfree((void**)&model->elements2d);

	/*Used later on: */
	my_grids=(int*)xcalloc(model->numberofnodes,sizeof(int));
	#endif

	#ifdef _PARALLEL_
	if(strcmp(model->meshtype,"2d")==0){
		ModelFetchData((void**)&model->elements,NULL,NULL,model_handle,"elements","Matrix","Mat");
		for (i=0;i<model->numberofelements;i++){
			if(my_rank==epart[i]){ 
				/*Now that we are here, we can also start building the list of grids belonging to this node partition: we use 
				 *the  element index to do this. For each element n, we know index[n][0:2] holds the indices (matlab indexing) 
				 into the grid coordinates. If we start plugging 1 into my_grids for each index[n][i] (i=0:2), then my_grids 
				 will hold which grids belong to this partition*/

				my_grids[(int)*(model->elements+elements_width*i+0)-1]=1;
				my_grids[(int)*(model->elements+elements_width*i+1)-1]=1;
				my_grids[(int)*(model->elements+elements_width*i+2)-1]=1;
			}
		}
	}
	else{
		ModelFetchData((void**)&model->elements,NULL,NULL,model_handle,"elements","Matrix","Mat");
		for (i=0;i<model->numberofelements;i++){
			if(my_rank==epart[i]){ 
				my_grids[(int)*(model->elements+elements_width*i+0)-1]=1;
				my_grids[(int)*(model->elements+elements_width*i+1)-1]=1;
				my_grids[(int)*(model->elements+elements_width*i+2)-1]=1;
				my_grids[(int)*(model->elements+elements_width*i+3)-1]=1;
				my_grids[(int)*(model->elements+elements_width*i+4)-1]=1;
				my_grids[(int)*(model->elements+elements_width*i+5)-1]=1;
			}
		}
	}

	/*From the element partitioning, we can determine which grids are on the inside of this cpu's 
	 *element partition, and which are on its border with other nodes:*/
	gridborder=NewVec(model->numberofnodes);

	for (i=0;i<model->numberofnodes;i++){
		if(my_grids[i])VecSetValue(gridborder,i,1,ADD_VALUES);
	}
	VecAssemblyBegin(gridborder);
	VecAssemblyEnd(gridborder);

	#ifdef _DEBUG_
	VecView(gridborder,PETSC_VIEWER_STDOUT_WORLD);
	#endif
	
	VecToMPISerial(&my_bordergrids,gridborder);

	#ifdef _DEBUG_
	if(my_rank==0){
		for (i=0;i<model->numberofnodes;i++){
			printf("Grid id %i Border grid %lf\n",i+1,my_bordergrids[i]);
		}
	}
	#endif
	#endif

	/*Hutter elements can be partitioned using epart, even if
	 * each hutter elements either lies on a node (in 2d), or a pair of vertically juxtaposed nodes (in 3d): */

	/*Fetch data temporarily needed: */
	ModelFetchData((void**)&model->gridonhutter,NULL,NULL,model_handle,"gridonhutter","Matrix","Mat");
	ModelFetchData((void**)&model->thickness,NULL,NULL,model_handle,"thickness","Matrix","Mat");
	ModelFetchData((void**)&model->surface,NULL,NULL,model_handle,"surface","Matrix","Mat");
	ModelFetchData((void**)&model->bed,NULL,NULL,model_handle,"bed","Matrix","Mat");
	ModelFetchData((void**)&model->gridonsurface,NULL,NULL,model_handle,"gridonsurface","Matrix","Mat");
	ModelFetchData((void**)&model->gridonbed,NULL,NULL,model_handle,"gridonbed","Matrix","Mat");
	ModelFetchData((void**)&model->uppernodes,NULL,NULL,model_handle,"uppergrids","Matrix","Mat");
	ModelFetchData((void**)&model->drag,NULL,NULL,model_handle,"drag","Matrix","Mat");
	ModelFetchData((void**)&model->B,NULL,NULL,model_handle,"B","Matrix","Mat");
	ModelFetchData((void**)&model->n,NULL,NULL,model_handle,"n","Matrix","Mat");

	/*2d mesh: */
	if (strcmp(model->meshtype,"2d")==0){

		for (i=0;i<model->numberofnodes;i++){
		#ifdef _PARALLEL_
		/*keep only this partition's nodes:*/
		if(my_grids[i]){
		#endif

			if(model->gridonhutter[i]){
				
				/*Deal with sing element: */
				sing_id=i+1; 
				sing_mid=i+1; //refers to the corresponding material property card
				sing_mparid=model->numberofnodes+1;//refers to the corresponding matpar property card
				sing_g=i+1;
				sing_h=model->thickness[i];
				sing_k=model->drag[i];

				/*Create sing element using its constructor:*/
				sing=new Sing(sing_id, sing_mid, sing_mparid, sing_g, sing_h, sing_k);

				/*Add tria element to elements dataset: */
				elements->AddObject(sing);

				/*Deal with material property card: */
				matice_mid=i+1; //same as the material id from the geom2 elements.
				matice_B=model->B[i];	
				matice_n=(double)model->n[1]; //n defined on elements not grids, so take the first value everywhere
			
				/*Create matice using its constructor:*/
				matice= new Matice(matice_mid,matice_B,matice_n);
	
				/*Add matice element to materials dataset: */
				materials->AddObject(matice);
			}

		#ifdef _PARALLEL_
		} //if(my_rank==npart[i])
		#endif

		} //for (i=0;i<model->numberofnodes;i++)
	} //if (strcmp(model->meshtype,"2d")==0)
	else{

		for (i=0;i<model->numberofnodes;i++){
		#ifdef _PARALLEL_
		/*keep only this partition's nodes:*/
		if(my_grids[i]){
		#endif

			if(model->gridonhutter[i]){

				if(!model->gridonsurface[i]){ 
					
					/*Deal with sing element: */
					beam_id=i+1; 
					beam_mid=i+1; //refers to the corresponding material property card
					beam_mparid=model->numberofnodes-model->numberofnodes2d+1;//refers to the corresponding matpar property card
					beam_g[0]=i+1;
					beam_g[1]=(int)model->uppernodes[i]; //grid that lays right on top
					beam_h[0]=model->thickness[i];
					beam_h[1]=model->thickness[(int)(model->uppernodes[i]-1)];
					beam_s[0]=model->surface[i];
					beam_s[1]=model->surface[(int)(model->uppernodes[i]-1)];
					beam_b[0]=model->bed[i];
					beam_b[1]=model->bed[(int)(model->uppernodes[i]-1)];
					beam_k[0]=model->drag[i];
					beam_k[1]=model->drag[(int)(model->uppernodes[i]-1)];

					beam_onbed=(bool)model->gridonbed[i];

					/*Create beam element ubeam its constructor:*/
					beam=new Beam(beam_id, beam_mid, beam_mparid, beam_g, beam_h, beam_s,beam_b,beam_k,beam_onbed);

					/*Add tria element to elements dataset: */
					elements->AddObject(beam);

					/*Deal with material property card: */
					matice_mid=i+1; //same as the material id from the geom2 elements.
					matice_B=model->B[i];	
					matice_n=(double)model->n[1]; //n defined on elements not grids, so take the first value everywhere
				
					/*Create matice ubeam its constructor:*/
					matice= new Matice(matice_mid,matice_B,matice_n);
		
					/*Add matice element to materials dataset: */
					materials->AddObject(matice);
				}
			}

		#ifdef _PARALLEL_
		} //if(my_rank==npart[i])
		#endif

		} //for (i=0;i<model->numberofnodes;i++)

	} //if (strcmp(model->meshtype,"2d")==0)
	

	/*Free data: */
	xfree((void**)&model->elements);
	xfree((void**)&model->gridonhutter);
	xfree((void**)&model->thickness);
	xfree((void**)&model->surface);
	xfree((void**)&model->bed);
	xfree((void**)&model->gridonsurface);
	xfree((void**)&model->uppernodes);
	xfree((void**)&model->drag);
	xfree((void**)&model->B);
	xfree((void**)&model->n);
	

	/*Add one constant material property to materials: */
	matpar_mid=model->numberofnodes-model->numberofnodes2d+1; //put it at the end of the materials
	matpar_g=model->g; 
	matpar_rho_ice=model->rho_ice; 
	matpar_rho_water=model->rho_water; 
	matpar_thermalconductivity=model->thermalconductivity; 
	matpar_heatcapacity=model->heatcapacity; 
	matpar_latentheat=model->latentheat; 
	matpar_beta=model->beta; 
	matpar_meltingpoint=model->meltingpoint; 
	matpar_mixed_layer_capacity=model->mixed_layer_capacity; 
	matpar_thermal_exchange_velocity=model->thermal_exchange_velocity; 

	/*Create matpar object using its constructor: */
	matpar=new Matpar(matpar_mid,matpar_rho_ice,matpar_rho_water,matpar_heatcapacity,matpar_thermalconductivity,
			matpar_latentheat,matpar_beta,matpar_meltingpoint,matpar_mixed_layer_capacity,
			matpar_thermal_exchange_velocity,matpar_g);
		
	/*Add to materials datset: */
	materials->AddObject(matpar);
	
	/*Create nodes from x,y,z, as well as the spc values on those grids: */
		
	/*First fetch data: */
	if (strcmp(model->meshtype,"3d")==0){
		ModelFetchData((void**)&model->deadgrids,NULL,NULL,model_handle,"deadgrids","Matrix","Mat");
		ModelFetchData((void**)&model->uppernodes,NULL,NULL,model_handle,"uppergrids","Matrix","Mat");
	}
	ModelFetchData((void**)&model->x,NULL,NULL,model_handle,"x","Matrix","Mat");
	ModelFetchData((void**)&model->y,NULL,NULL,model_handle,"y","Matrix","Mat");
	ModelFetchData((void**)&model->z,NULL,NULL,model_handle,"z","Matrix","Mat");
	ModelFetchData((void**)&model->thickness,NULL,NULL,model_handle,"thickness","Matrix","Mat");
	ModelFetchData((void**)&model->bed,NULL,NULL,model_handle,"bed","Matrix","Mat");
	ModelFetchData((void**)&model->gridonbed,NULL,NULL,model_handle,"gridonbed","Matrix","Mat");
	ModelFetchData((void**)&model->gridonsurface,NULL,NULL,model_handle,"gridonsurface","Matrix","Mat");
	ModelFetchData((void**)&model->gridonhutter,NULL,NULL,model_handle,"gridonhutter","Matrix","Mat");
	ModelFetchData((void**)&model->gridonicesheet,NULL,NULL,model_handle,"gridonicesheet","Matrix","Mat");
	ModelFetchData((void**)&model->gridoniceshelf,NULL,NULL,model_handle,"gridoniceshelf","Matrix","Mat");
	
	/*Get number of dofs per node: */
	DistributeNumDofs(&node_numdofs,analysis_type,sub_analysis_type);

	for (i=0;i<model->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if(my_grids[i]){
	#endif

		node_id=i+1; //matlab indexing
			

		#ifdef _PARALLEL_
		if(my_bordergrids[i]>1.0) { //this grid belongs to a partition border
			node_partitionborder=1;
		}
		else{
			node_partitionborder=0;
		}
		#else
			node_partitionborder=0;
		#endif

		node_x[0]=model->x[i];
		node_x[1]=model->y[i];
		node_x[2]=model->z[i];
		node_sigma=(model->z[i]-model->bed[i])/(model->thickness[i]);
		
		node_onbed=(int)model->gridonbed[i];
		node_onsurface=(int)model->gridonsurface[i];	
		node_onshelf=(int)model->gridoniceshelf[i];	
		node_onsheet=(int)model->gridonicesheet[i];	

		if (strcmp(model->meshtype,"3d")==0){
			if (isnan(model->uppernodes[i])){
				node_upper_node_id=node_id;  //nodes on surface do not have upper nodes, only themselves.
			}
			else{
				node_upper_node_id=(int)model->uppernodes[i];
			}
		}
		else{
			/*If we are running 2d, upper_node does not mean much. Just point towards itself!:*/
			node_upper_node_id=node_id;
		}

		/*Create node using its constructor: */
		node=new Node(node_id,node_partitionborder,node_numdofs,node_x,node_sigma,node_onbed,node_onsurface,node_upper_node_id,node_onshelf,node_onsheet);

		/*set single point constraints.: */
		if (!model->gridonhutter[i]){
			for(k=1;k<=node_numdofs;k++){
				node->FreezeDof(k);
			}
		}

		/*Add node to nodes dataset: */
		nodes->AddObject(node);

	#ifdef _PARALLEL_
	} //if(my_grids[i])
	#endif
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	elements->Presort();
	nodes->Presort();
	materials->Presort();

	/*Clean fetched data: */
	xfree((void**)&model->deadgrids);
	xfree((void**)&model->x);
	xfree((void**)&model->y);
	xfree((void**)&model->z);
	xfree((void**)&model->thickness);
	xfree((void**)&model->bed);
	xfree((void**)&model->gridonbed);
	xfree((void**)&model->gridonsurface);
	xfree((void**)&model->gridonhutter);
	xfree((void**)&model->uppernodes);
	xfree((void**)&model->gridonicesheet);
	xfree((void**)&model->gridoniceshelf);
	

	/*Keep partitioning information into model*/
	model->epart=epart;
	model->my_grids=my_grids;
	model->my_bordergrids=my_bordergrids;

	/*Keep partitioning information into model*/
	#ifdef _PARALLEL_
	xfree((void**)&all_numgrids);
	xfree((void**)&npart);
	VecFree(&gridborder);
	#endif
	model->npart=npart;

	cleanup_and_return:

	/*Assign output pointer: */
	*pelements=elements;
	*pnodes=nodes;
	*pmaterials=materials;

}
