/*\file NodeConnectivity.c
 *\brief: build node connectivity from elements. 
 */

#include "./NodeConnectivity.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*inputs: */
	double* elements=NULL;
	int     nel,nods;

	/*outputs: */
	double* connectivity=NULL;
	int     width;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&NodeConnectivityUsage);
        
	/*Input datasets: */
	FetchData((void**)&elements,&nel,NULL,ELEMENTS,"Matrix","Mat");
	FetchData((void**)&nods,NULL,NULL,NUMNODES,"Integer",NULL);

	/*!Generate internal degree of freedom numbers: */
	NodeConnectivityx(&connectivity, &width,elements,nel, nods);

	/*write output datasets: */
	WriteData(CONNECTIVITY,connectivity,nods,width,"Matrix","Mat");

	/*Free ressources: */
	xfree((void**)&elements);

	/*end module: */
	MODULEEND();
}

void NodeConnectivityUsage(void) {
	_printf_("\n");
	_printf_("   usage: connectivity = %s(elements, numnodes);\n",__FUNCT__);
	_printf_("\n");
}
