%Quick documentation for ISSM

%First get ISSM tier: 
ISSM_TIER=issmtier;

disp(sprintf('\n%s','  A comprehensive documentation is available on http://issm.jpl.nasa.gov'));
disp(sprintf('\n%s','  Example: how to create a square ice shelf'));
disp(sprintf('%s','	   go to ',ISSM_TIER,'/examples/SquareIceshelf'));
disp(sprintf('%s','	   md=model;                                %creates a new empty model structure'));
disp(sprintf('%s','	   md=mesh(md,''DomainOutline.exp'',50000);   %creates a mesh of the domain outline with a resolution of 50000m'));
disp(sprintf('%s','	   md=geography(md,''all'','''');               %defines the glacier system as an ice shelf (no island)'));
disp(sprintf('%s','	   md=parameterize(md,''Square.par'');        %fills all the other fields of the model'));
disp(sprintf('%s','	   md=setelementstype(md,''macayeal'',''all''); %defines all elements as MacAyeal''s'));
disp(sprintf('%s','	   md=solve(md,''analysis_type'',''diagnostic'',''package'',''ice'');   %generate the velocity field of the ice shelf using the solver ICE'));
disp(sprintf('%s','	   plotmodel(md,''data'',md.results.diagnostic.vel);              %displays the velocity (type plotdoc for plotmodel help)'));
