md=triangle(model,'../Exp/Pig.exp',30000);
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setflowequation(md,'pattyn','all');
md.thermal.stabilization=2;
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature1','BasalforcingsMeltingRate1', ...
				      'Temperature2','BasalforcingsMeltingRate2'};
field_tolerances={1e-13,1e-8,1e-13,1e-8};
field_values={...
	(md.results.ThermalSolution(1).Temperature),...
	(md.results.ThermalSolution(1).BasalforcingsMeltingRate),...
	(md.results.ThermalSolution(2).Temperature),...
	(md.results.ThermalSolution(2).BasalforcingsMeltingRate),...
	};
