/*! \file BoolElementResult.h 
 *  \brief: header file for bool result object
 *  A boll result object is just derived from a BoolInput object, with additional time and step information.
 */


#ifndef _BOOLELEMENTRESULT_H_
#define _BOOLELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
class Parameters;
/*}}}*/

class BoolElementResult: public ElementResult{

	private: 
		int    enum_type;
		bool   value;
		int    step;
		double time;

	public:

		/*BoolElementResult constructors, destructors: {{{1*/
		BoolElementResult();
		BoolElementResult(int enum_type,bool value,int step,double time);
		~BoolElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnTriaElementResult(int* indices);
		double  GetTime(void){return time;};
		int     GetStep(void){return step;};
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*BoolElementResult management: {{{1*/
		int   InstanceEnum();
		void GetVectorFromResults(Vec vector,int* doflist,int numdofs);
		/*}}}*/
};
#endif  /* _BOOLELEMENTRESULT_H */
