#!/bin/bash
#Script to synchronize trunk and trunk-jpl
#http://svnbook.red-bean.com/nightly/en/svn.branchmerge.advanced.html#svn.branchmerge.advanced.reintegratetwice
#
#
#  ___A___________________X______________________________  trunk
#     \            \     /
#      \      merge \   / reintegrate
#       \____________ B _________________________________  trunk-jpl (branch)
#
#Step 1: update both branches
#Step 2: merge trunk back to trunk-jpl
#        cd trunk-jpl
#        svn merge -r A:HEAD ../trunk
#        svn commit -m "merged trunk and trun-jpl for revision HEAD"
#Step 3: reintegrate trunk-jpl in trunk
#        cd trunk
#        svn merge --reintegrate https://issm.ess.uci.edu:80/svn/issm/issm/trunk-jpl
#        svn commit -m "merged trunk-jpl and trunk for revision HEAD"
#Step 4: record reintegration
#        svn merge --record-only -c X ../trunk
#        svn commit -m "Block revision X from being merged into trunk-jpl"

STEP=1
LASTMERGEREVISION=`cat LastMerge`

#Check user and get PATH
if [[ $USER != "larour" ]]; then
	echo "you are not allowed to synchronize trunk and trunk-jpl" && exit 1 
fi
PREFIX=$(pwd)/../

if [ "$STEP" -eq "1" ]; then
	echo "--- Step 1: updating trunk and trunk-jpl ---"
	cd $PREFIX/trunk
	svn update
	cd $PREFIX/trunk-jpl
	svn update
fi
if [ "$STEP" -eq "2" ]; then
	echo "--- Step 2: merging trunk in trunk-jpl ---"
	cd $PREFIX/trunk-jpl
	svn merge -r $LASTMERGEREVISION:HEAD ../trunk
	svn commit -m "merged trunk and trunk-jpl"
fi
if [ "$STEP" -eq "3" ];
then
	echo "--- Step 3: reintegrate trunk-jpl in trunk ---"
	cd $PREFIX/trunk
	svn update
	B=$(svnversion .)
	svn merge --reintegrate https://issm.ess.uci.edu:80/svn/issm/issm/trunk-jpl
	svn commit -m "merged trunk-jpl and trunk for revision $B"
fi
if [ "$STEP" -eq "4" ];
then
	echo "--- Step 4: record reintegration ---"
	cd $PREFIX/trunk-jpl
	X=$(svnversion . | sed -e "s/:/ /" | awk {'print $2'})
	echo $X > ../oecreview/LastMerge
	svn merge --record-only -c $X ../trunk
	svn commit -m "Block revision $X from being merged into trunk-jpl"
fi
