md=setmesh(model,'../Exp/SquareHole.exp','../Exp/Rifts.exp',50000);
md=meshprocessrifts(md,'../Exp/Square.exp');
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);

%rift settings
md.rifts.riftstruct.fill=MelangeEnum();
md.rifts.riftstruct.fraction=0;
md.diagnostic.rift_penalty_lock=2;
md.diagnostic.rift_penalty_threshold=0;
md.rifts.riftstruct.fractionincrement=.1;
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure'};
field_tolerances={1e-11,1e-11,1e-11,1e-11};
field_values={...
	(md.results.DiagnosticSolution.Vx),...
	(md.results.DiagnosticSolution.Vy),...
	(md.results.DiagnosticSolution.Vel),...
	(md.results.DiagnosticSolution.Pressure),...
	};
