%AUTODIFF class definition
%
%   Usage:
%      autodiff=autodiff();

classdef autodiff
	properties (SetAccess=public) 
		isautodiff = false;
		forward    = true;
		reverse    = false;
	end
	methods
		function obj = autodiff(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   automatic differentiation parameters:'));

			fielddisplay(obj,'isautodiff','indicates if the automatic differentiation is activated');
			fielddisplay(obj,'forward','forward differentiation');
			fielddisplay(obj,'reverse','backward differentiation');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','isautodiff','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','forward','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','reverse','format','Boolean');
		end % }}}
	end
end
