function dhdt=thicknessevolution(md)
%THICKNESSEVOLUTION - compute the new thickness of a model after ∆t
%
%   This routine compute the new thickness of a model after a time step
%   according to the following formula:
%   dh/dt=-div(Hu)
%
%   Usage:
%      dhdt=thicknessevolution(md)

if (length(md.vx)~=md.numberofgrids)|(length(md.vy)~=md.numberofgrids)
	error('thicknessevolution error message: velocity empty')
end

%load some variables (it is much faster if the variab;es are loaded from md once for all) 
numberofelements=md.numberofelements;
H=md.thickness;
vx=md.vx;
vy=md.vy;
index=md.elements;
x=md.x; y=md.y;

%initialization
alpha=zeros(md.numberofelements,3);
beta=zeros(md.numberofelements,3);
gradx=zeros(md.numberofgrids,1);
grady=zeros(md.numberofgrids,1);

%build some usefull variables
line=index(:);
summation=1/3*ones(3,1);
linesize=3*numberofelements;
x1=x(index(:,1)); x2=x(index(:,2)); x3=x(index(:,3)); y1=y(index(:,1)); y2=y(index(:,2)); y3=y(index(:,3));

%compute nodal functions coefficients N(x,y)=alpha x + beta y + gamma
invdet=1./(x1.*(y2-y3)-x2.*(y1-y3)+x3.*(y1-y2));
alpha=[invdet.*(y2-y3) invdet.*(y3-y1) invdet.*(y1-y2)];
beta=[invdet.*(x3-x2) invdet.*(x1-x3) invdet.*(x2-x1)];

%compute dhdt=div(Hu)
Hvx=H.*vx; Hvy=H.*vy;
dhdt=-sum(Hvx(index).*alpha,2)-sum(Hvy(index).*beta,2);
