md=setmesh(model,'../Exp/Square.exp',180000);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,5,2);
md=setflowequation(md,'hutter','all');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.DiagnosticSolution.Vx),...
	(md.results.DiagnosticSolution.Vy),...
	(md.results.DiagnosticSolution.Vz),...
	(md.results.DiagnosticSolution.Vel),...
	(md.results.DiagnosticSolution.Pressure),...
	};
