md=setmesh(model,'../Exp/Square.exp',150000);
md=meshconvert(md);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md.balancethickness.stabilization=3;
md.initialization.vy=md.initialization.vy+400;
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,BalancethicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Thickness'};
field_tolerances={1e-13};
field_values={...
	(md.results.BalancethicknessSolution.Thickness),...
	};
