md=setmesh(model,'../Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,5,1);
md=setflowequation(md,'macayeal','all');
md.cluster=none;
md=solve(md,SurfaceSlopeSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'SurfaceSlopeX','SurfaceSlopeY'};
field_tolerances={1e-13,1e-13};
field_values={...
	(md.results.SurfaceSlopeSolution.SurfaceSlopeX),...
	(md.results.SurfaceSlopeSolution.SurfaceSlopeY),...
	};
