md=setmesh(model,'../Exp/Square.exp',180000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,3,1);
md=setflowequation(md,'macayeal','all');
md.cluster=none;
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	(md.results.ThermalSolution(1).Temperature),...
	(md.results.ThermalSolution(1).BasalforcingsMeltingRate),...
	};
