%SETTINGS class definition
%
%   Usage:
%      settings=settings();

classdef settings
	properties (SetAccess=public) 
		io_gather           = 0;
		lowmem              = 0;
		results_on_vertices = 0;
		output_frequency    = 0;
		waitonlock          = 0;
	end
	methods
		function obj = settings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%are we short in memory ? (0 faster but requires more memory)
			obj.lowmem=0;

			%i/o:
			obj.io_gather=1;

			%results frequency by default every step
			obj.output_frequency=1;

			%this option can be activated to load automatically the results
			%onto the model after a parallel run by waiting for the lock file
			%N minutes that is generated once the solution has converged
			%0 to desactivate
			obj.waitonlock=Inf;
		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			checkfield(md,'settings.io_gather','numel',1,'values',[0 1]);
			checkfield(md,'settings.lowmem','numel',1,'values',[0 1]);
			checkfield(md,'settings.results_on_vertices','numel',1,'values',[0 1]);
			checkfield(md,'settings.output_frequency','numel',1,'>=',1);
			checkfield(md,'settings.waitonlock','numel',1);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   general settings parameters:'));

			fielddisplay(obj,'io_gather','I/O gathering strategy for result outputs (default 1)');
			fielddisplay(obj,'lowmem','is the memory limited ? (0 or 1)');
			fielddisplay(obj,'results_on_vertices','provide results on vertices instead of patch (0 or 1)');
			fielddisplay(obj,'output_frequency','frequency at which results are saved in all solutions with multiple time_steps');
			fielddisplay(obj,'waitonlock','maximum number of minutes to wait for batch results, or return 0');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','io_gather','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','lowmem','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','results_on_vertices','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','output_frequency','format','Integer');
			WriteData(fid,'object',obj,'fieldname','waitonlock','format','Boolean');
		end % }}}
	end
end
