%MISCELANEOUS class definition
%
%   Usage:
%      miscellaneous=miscellaneous();

classdef miscellaneous
	properties (SetAccess=public) 
		notes = '';
		name  = '';
		dummy = struct();
	end
	methods
		function obj = miscellaneous(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			checkfield(md,'miscellaneous.name','empty',1);

		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   miscellaneous parameters:'));

			fielddisplay(obj,'notes','notes in a cell of strings');
			fielddisplay(obj,'name','model name');
			fielddisplay(obj,'dummy','empty field to store some data');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','name','format','String');
		end % }}}
	end
end
