#include "petsc.h"
#include "petscfix.h"
/* stsolve.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepcst.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stapply_ STAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stapply_ stapply
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stapplyb_ STAPPLYB
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stapplyb_ stapplyb
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stapplynob_ STAPPLYNOB
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stapplynob_ stapplynob
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stapplytranspose_ STAPPLYTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stapplytranspose_ stapplytranspose
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stcomputeexplicitoperator_ STCOMPUTEEXPLICITOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stcomputeexplicitoperator_ stcomputeexplicitoperator
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stnorm_ STNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stnorm_ stnorm
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stnormbegin_ STNORMBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stnormbegin_ stnormbegin
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stnormend_ STNORMEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stnormend_ stnormend
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stinnerproduct_ STINNERPRODUCT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stinnerproduct_ stinnerproduct
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stinnerproductbegin_ STINNERPRODUCTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stinnerproductbegin_ stinnerproductbegin
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stinnerproductend_ STINNERPRODUCTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stinnerproductend_ stinnerproductend
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stminnerproduct_ STMINNERPRODUCT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stminnerproduct_ stminnerproduct
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stminnerproductbegin_ STMINNERPRODUCTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stminnerproductbegin_ stminnerproductbegin
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stminnerproductend_ STMINNERPRODUCTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stminnerproductend_ stminnerproductend
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stsetup_ STSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stsetup_ stsetup
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stpostsolve_ STPOSTSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stpostsolve_ stpostsolve
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define stbacktransform_ STBACKTRANSFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define stbacktransform_ stbacktransform
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  stapply_(ST *st,Vec x,Vec y, int *__ierr ){
*__ierr = STApply(*st,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL  stapplyb_(ST *st,Vec x,Vec y, int *__ierr ){
*__ierr = STApplyB(*st,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL  stapplynob_(ST *st,Vec x,Vec y, int *__ierr ){
*__ierr = STApplyNoB(*st,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL  stapplytranspose_(ST *st,Vec x,Vec y, int *__ierr ){
*__ierr = STApplyTranspose(*st,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL  stcomputeexplicitoperator_(ST *st,Mat *mat, int *__ierr ){
*__ierr = STComputeExplicitOperator(*st,mat);
}
void PETSC_STDCALL  stnorm_(ST *st,Vec x,PetscReal *norm, int *__ierr ){
*__ierr = STNorm(*st,
	(Vec)PetscToPointer((x) ),norm);
}
void PETSC_STDCALL  stnormbegin_(ST *st,Vec x,PetscReal *norm, int *__ierr ){
*__ierr = STNormBegin(*st,
	(Vec)PetscToPointer((x) ),norm);
}
void PETSC_STDCALL  stnormend_(ST *st,Vec x,PetscReal *norm, int *__ierr ){
*__ierr = STNormEnd(*st,
	(Vec)PetscToPointer((x) ),norm);
}
void PETSC_STDCALL  stinnerproduct_(ST *st,Vec x,Vec y,PetscScalar *p, int *__ierr ){
*__ierr = STInnerProduct(*st,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ),p);
}
void PETSC_STDCALL  stinnerproductbegin_(ST *st,Vec x,Vec y,PetscScalar *p, int *__ierr ){
*__ierr = STInnerProductBegin(*st,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ),p);
}
void PETSC_STDCALL  stinnerproductend_(ST *st,Vec x,Vec y,PetscScalar *p, int *__ierr ){
*__ierr = STInnerProductEnd(*st,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ),p);
}
void PETSC_STDCALL  stminnerproduct_(ST *st,PetscInt *n,Vec x, Vec y[],PetscScalar *p, int *__ierr ){
*__ierr = STMInnerProduct(*st,*n,
	(Vec)PetscToPointer((x) ),y,p);
}
void PETSC_STDCALL  stminnerproductbegin_(ST *st,PetscInt *n,Vec x, Vec y[],PetscScalar *p, int *__ierr ){
*__ierr = STMInnerProductBegin(*st,*n,
	(Vec)PetscToPointer((x) ),y,p);
}
void PETSC_STDCALL  stminnerproductend_(ST *st,PetscInt *n,Vec x, Vec y[],PetscScalar *p, int *__ierr ){
*__ierr = STMInnerProductEnd(*st,*n,
	(Vec)PetscToPointer((x) ),y,p);
}
void PETSC_STDCALL  stsetup_(ST *st, int *__ierr ){
*__ierr = STSetUp(*st);
}
void PETSC_STDCALL  stpostsolve_(ST *st, int *__ierr ){
*__ierr = STPostSolve(*st);
}
void PETSC_STDCALL  stbacktransform_(ST *st,PetscScalar* eigr,PetscScalar* eigi, int *__ierr ){
*__ierr = STBackTransform(*st,eigr,eigi);
}
#if defined(__cplusplus)
}
#endif
