%this test computes the time needed for a diagnostic in 2d
%depending on the connectivity

%1: connectivity
Connectivity=13:23;

%2: Density
%Density=5000:1000:9000;  %parallel 2d
Density=20000:1000:24000;  %parallel 3d

%3: test 3d?
is3d=1;

%4: test parallel?
isparallel=1;

%5: number of CPU (if parallel)
np=3;

%loop over every case
count=1;
time=zeros(length(Density),length(Connectivity));
numelements=zeros(length(Density));
numcases=length(Density)*length(Connectivity);
subplotwidth=ceil(sqrt(length(Density)));
for i=1:length(Density),
	for j=1:length(Connectivity),
		density=Density(i);
		connectivity=Connectivity(j);

		disp(sprintf('\nSTEP %i/%i : (density=%i, connectivity=%i)\n',count,numcases,density,connectivity));

		%create model
		md=model;
		md=setmesh(md,'DomainOutline.exp',density);
		md=setmask(md,'all','');
		md=parameterize(md,'Square.par');
		md.average_vertex_connectivity=connectivity;
		md.np=np;
		if is3d,
			md=extrude(md,4,5);
			md=setflowequation(md,'pattyn','all');
		else
			md=setflowequation(md,'macayeal','all');
		end

		%diagnostic
		t1=clock;
		if isparallel
			md.cluster='wilkes';
			md=solve(md,'diagnostic_horiz');
		else
			md=solve(md,'diagnostic');
		end
		t2=clock;

		%save time
		time(i,j)=etime(t2,t1);
		count=count+1;

	end
	numelements(i)=md.mesh.numberofelements;
end

%display result
disp(sprintf('\nResults\n'));
disp(sprintf('   STEP  density  connectivity   time',count));
for i=1:length(Density),
	for j=1:length(Connectivity),
		disp(sprintf(['%4i/%i %i %11i        ' num2str(time(i,j))],count,numcases,Density(i),Connectivity(j)));
		count=count+1;
	end
	[dummy pos]=min(time(i,:));

	%plot results
	subplot(subplotwidth,subplotwidth,i)
	plot(Connectivity,time(i,:));
	hold on
	plot([Connectivity(1);Connectivity(end)],time(i,pos)*ones(2,1),'-r');

	title(['computation time for '  num2str(numelements(i)) ' elements'],'FontSize',14);
	xlabel('Connectivity','FontSize',14)
	ylabel('time (s)','FontSize',14)
end
