/*\file UpdateDynamicConstraints.c
 *\brief: update single point constraints inside nodes out of constrain vector ys
 */

#include "./UpdateDynamicConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Constraints *constraints = NULL;
	Nodes       *nodes       = NULL;
	Parameters  *parameters  = NULL;
	Vec          yg          = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateDynamicConstraintsUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&constraints,CONSTRAINTSIN);
	FetchMatlabData((DataSet**)&nodes,NODESIN);
	FetchMatlabData((Parameters**)&parameters,PARAMETERS);
	FetchMatlabData(&yg,YG);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateDynamicConstraintsx(constraints,nodes,parameters,yg);

	/*write output datasets: */
	WriteMatlabData(CONSTRAINTSOUT,constraints);

	/*Free ressources: */
	VecFree(&yg);
	delete constraints;
	delete nodes;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void UpdateDynamicConstraintsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: m.constraints=%s(m.constraints,m.nodes,m.parameters,ys);\n",__FUNCT__);
	_printf_(true,"\n");
}
