/*\file ControlOptimization.c
 *\brief: control optimization (replaces fmincon from matlab)
 */

#include "./ControlOptimization.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	char* function_name=NULL;
	double xmin,xmax;
	double* maxiter;
	OptArgs optargs;
	OptPars optpars;

	/*output: */
	double search_scalar;
	double J;

	/*arguments to objectivefunctionC: */
	int      n_value;
	double*  threshold=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlOptimizationUsage);

	/*Input datasets: */
	FetchMatlabData(&function_name,FUNCTIONNAME);
	FetchMatlabData(&xmin,XMIN);
	FetchMatlabData(&xmax,XMAX);

	/*Parameters: */
	FetchMatlabData(&maxiter,NULL,NULL,mxGetField(OPTIONS,0,"MaxIter"));
	FetchMatlabData(&threshold,NULL,NULL,mxGetField(PARAMETERS,0,"InversionStepThreshold"));
	FetchMatlabData(&n_value,STEP);

	optargs.function_name=function_name;
	optargs.femmodel=FEMMODEL;

	optpars.xmin=xmin;
	optpars.xmax=xmax;
	optpars.maxiter=(int)maxiter[n_value-1];
	optpars.cm_jump=threshold[n_value-1];

	BrentSearch(&search_scalar,&J,&optpars,&OptFunc,&optargs);

	/*write output : */
	WriteMatlabData(SEARCHSCALAR,search_scalar);
	WriteMatlabData(MISFIT,J);

	/*Free ressources: */
	xfree((void**)&function_name);
	xfree((void**)&threshold);
	xfree((void**)&maxiter);

	/*end module: */
	MODULEEND();
}

void ControlOptimizationUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [search_scalar J] = %s(function_name,xmin,xmax,options,femmodel,step,parameters)\n",__FUNCT__);
	_printf_(true,"\n");
}
