/*\file BamgTriangulate.c
 *\brief: bamg module.
 */
#include "./BamgTriangulate.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input: */
	double* x=NULL;
	double* y=NULL;
	int     x_cols;
	int     y_rows,y_cols;
	int nods;

	/*Output*/
	int* index=NULL;
	int  nels;

	/*Intermediary*/
	int verbose=0;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgTriangulateUsage);

	/*Input datasets: */
	if (verbose) printf("Fetching inputs\n");
	FetchMatlabData(&x,&nods,&x_cols,XHANDLE);
	FetchMatlabData(&y,&y_rows,&y_cols,YHANDLE);

	/*Check inputs*/
	if(y_rows!=nods)         _error_("x and y do not have the same length");
	if(x_cols>1 || y_cols>1) _error_("x and y should have only one column");
	if(nods<3)               _error_("At least 3 points are required");

	/* Run core computations: */
	if (verbose) printf("Call core\n");
	BamgTriangulatex(&index,&nels,x,y,nods);

	/*Write output*/
	WriteMatlabData(INDEX,index,nels,3);

	/*end module: */
	MODULEEND();
}

void BamgTriangulateUsage(void)
{
	_printf_(true,"BAMGTRIANGULATE - Delaunay Triangulation of a list of points");
	_printf_(true,"\n");
	_printf_(true,"   Usage:\n");
	_printf_(true,"      index=BamgTriangulate(x,y);\n");
	_printf_(true,"      index: index of the triangulation\n");
	_printf_(true,"      x,y: coordinates of the nodes\n");
	_printf_(true,"\n");
}
