function [A ,B]=glen_coefficients(Ao,T);
%GLEN_COEFFICIENTS - compute A and B, given the temperature and Ao
%
%   Ao,T according to patterson,Ao in s-1kPa-3.
%   values range between 3.9 and 5.3*10^-16;
%   Return: A in s-1kPa-3. B in Pa.a1/3
%
%   Usage:
%      [A ,B]=glen_coefficients(Ao,T)

To=263;
R=8.314;
E1=139000;
E2=60000;

%For T>263,
Ac1=Ao*exp(E1/R/To);
%For T<263,
Ac2=Ao*exp(E2/R/To);

A=Ac1*exp(-E1/R./T);
pos=find(T<263);
A(pos)=Ac2*exp(-E2/R./T(pos));

B=(A*365*24*3600).^(-1/3);

