function flag=FlagElements(md,region),
%FLAGELEMENTS - flag the elements in an region
%
%   The region can be given with an exp file, a list of elements.
%
%   Usage: 
%      flag=FlagElements(md,region);
%
%   Example:
%      flag=FlagElements(md,'all');
%      flag=FlagElements(md,'');
%      flag=FlagElements(md,'Domain.exp');
%      flag=FlagElements(md,'~Domain.exp');
%      flag=FlagElements(md,md.mask.elementongroundedice);

	if ischar(region),
		if isempty(region),
			flag=zeros(md.mesh.numberofelements,1);
			invert=0;
		elseif strcmpi(region,'all')
			flag=ones(md.mesh.numberofelements,1);
			invert=0;
		else
			%make sure that we actually don't want the elements outside the domain outline!
			if strcmpi(region(1),'~'),
				region=region(2:length(region));
				invert=1;
			else
				invert=0;
			end

			%does the region domain outline exist or do we have to look for xlim,ylim in basinzoom?
			if ~exist(region,'file'),
				[xlim,ylim]=basinzoom('basin',region);
				flag_nodes=double(md.mesh.x<xlim(2) & md.mesh.x>xlim(1) &  md.mesh.y<ylim(2) & md.mesh.y>ylim(1));
				flag=prod(flag_nodes(md.mesh.elements),2);
			else
				%ok, flag elements
				flag=ContourToMesh(md.mesh.elements(:,1:3),md.mesh.x,md.mesh.y,region,'element',1);
			end
		end
		if invert,
			flag=~flag;
		end
	elseif isfloat(region) | islogical(region),
		if size(region,1)~=md.mesh.numberofelements,
			help FlagElements
			error('Flaglist for region must be of same size as number of elements in model');
		end
		flag=region;
	else
		error('Invalid region option');
	end
end
