function expgen(file_name,contours,close_flag);
%EXPGEN - create an Argus file from x and y arrays
%
%   Create .exp domain outline type out of x,y  coordinates. 
%   The contour defined by arrays x and y should not be closed. 
%   Generated domain outline will not be closed, except if close_flag is set to 1.
%
%   Usage:
%      expgen(file_name,contours,close_flag)
%
%   See also EXPMASTER, EXPDOC

%Check on inputs
if((close_flag~=0) & (close_flag~=1)),
error('close flag must be 0 of 1');
end
fid=fopen(file_name,'wt');

for i=1:length(contours),
	if(length(contours(i).x)~=length(contours(i).y)),
	error('contours x and y coordinates must be of identical size');
	end

	%get density for this profile.
	if isfield(contours,'density'),
		density=contours(i).density;
	end

	fprintf(fid,'%s\n','## Name:');
	fprintf(fid,'%s\n','## Icon:0');
	fprintf(fid,'%s\n','# Points Count Value');
	if(close_flag==0),
	fprintf(fid,'%i %i\n',length(contours(i).x),density);
	else
	fprintf(fid,'%i %i\n',length(contours(i).x)+1,density);
	end
	fprintf(fid,'%s\n','# X pos Y pos');
	for j=1:length(contours(i).x),
	 fprintf(fid,'%f %f\n',contours(i).x(j),contours(i).y(j));
	end  

	if(close_flag==1),
	fprintf(fid,'%f %f\n',contours(i).x(1),contours(i).y(1));
	end
	fprintf(fid,'%s\n','');
end
fclose(fid);
