function md=issm(md,solution_type);
%ISSM - ISSM main parallel program
%
%   Usage:
%      md=issm(md)
%
	%timing
	t1=clock;
	disp('launching solution sequence');

	%out of solution_type, figure types of analyses needed:
	[analyses,numanalyses]=AnalysisConfiguration(solution_type);

	%create finite element model
	femmodel=NewFemModel(md,solution_type,analyses,numanalyses);

	%out of solution_type, figure out solution core function pointer
	[solutioncore]=CorePointerFromSolutionEnum(femmodel.parameters,solution_type);
	
	%process petsc options: 
	femmodel.parameters=ParsePetscOptions(femmodel.parameters,[md.miscellaneous.name '.petsc']);

	%retrieve parameters
	dakota_analysis=femmodel.parameters.QmuIsdakota;
	control_analysis=femmodel.parameters.InversionIscontrol;

	%compute solution
	issmprintf(VerboseSolution,'%s',['call computational core']);
	if dakota_analysis,
		Dakota(femmodel);
	elseif control_analysis
		femmodel=control_core(femmodel);
	else
		eval(['femmodel=' solutioncore '(femmodel);']);
	end

	issmprintf(VerboseSolution,'%s',['write results'])
	md.results.(EnumToString(solution_type))=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);

	%stop timing
	t2=clock;
	disp(['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
