function [adjointcore]=AdjointCorePointerFromSolutionEnum(solutiontype),
%COREPOINTERFROMSOLUTIONENUM - returns solution_core function
%
%   Usage:
%      [adjointcore]=AdjointCorePointerFromSolutionEnum(solutiontype);

switch solutiontype,

	case DiagnosticSolutionEnum,         adjointcore='adjointdiagnostic_core';
	case SteadystateSolutionEnum,        adjointcore='adjointdiagnostic_core';
	case BalancethicknessSolutionEnum,   adjointcore='adjointbalancethickness_core';
	otherwise error('%s%s%s',' solution type: ',EnumToString(solutiontype),' not supported yet!');

end
