function options=asmoptions(varargin)
%ASMOPTIONS - return Additive Shwartz Method petsc options
%
%   Usage:
%      options=asmoptions;
			 
%retrieve options provided in varargin
arguments=pairoptions(varargin{:});

%default asm options
options={{'mat_type','aij'},{'ksp_type','gmres'},{'pc_type','asm'},{'sub_pc_type','lu'},{'pc_asm_overlap',3},{'ksp_max_it',100},{'ksp_rtol',1e-30'}};

%now, go through our arguments, and write over default options.
for i=1:size(arguments.list,1),
	arg1=arguments.list{i,1};
	arg2=arguments.list{i,2};
	found=0;
	for j=1:size(options,2),
		joption=options{j};
		if strcmpi(joption{1},arg1),
			joption{2}=arg2;
			options{j}=joption;
			found=1;
			break;
		end
	end
	if ~found,
		%this option did not exist, add it: 
		options{end+1}={arg1,arg2};
	end
end
