function [direction,direction2]=graddetection(md)
%GRADDETECTION detect gradient of control method between steps nsteps+1 and nsteps
%
% Usage: direction=graddetection(md);

%keep copy of md: 
md2=md;

%solve first batch of control methods, with given settings.
md2=solve(md2,'solution_type','DiagnosticAnalysis');

%record final optimized parameter. 
parameter1=md2.results.DiagnosticAnalysis.parameter;

%plug optimized parameter in model. 
md2.(EnumToModelField(md2.results.DiagnosticAnalysis.inversion.control_parameters))=parameter1;

%put nsteps to 1: 
md2.nsteps=1;
md2.optscal=md2.optscal(end)*ones(md2.nsteps,1);
md2.fit=md2.fit(end)*ones(md2.nsteps,1);
md2.cm_jump=md2.cm_jump(end)*ones(md2.nsteps,1);
md2.maxiter=md2.maxiter(end)*ones(md2.nsteps,1);

%rerun control method with optimized parameter, only for 1 more step.
md2=solve(md2,'solution_type','DiagnosticAnalysis');

%get optimized parameter after 1 more step. 
parameter2=md2.results.DiagnosticAnalysis.parameter;

%return relative  difference between nsteps+1 and nsteps;
direction=(parameter2-parameter1)./parameter1;
direction2=(parameter2-parameter1);
