%GEOMETRY class definition
%
%   Usage:
%      geometry=geometry();

classdef geometry
	properties (SetAccess=public) 
		surface           = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',SurfaceEnum);
		thickness         = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',ThicknessEnum);
		bed               = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',BedEnum);
		bathymetry        = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',BathymetryEnum);
		hydrostatic_ratio = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = geometry(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			checkfield(md,'geometry.surface'  ,'NaN',1,'size',[md.mesh.numberofvertices 1]);
			checkfield(md,'geometry.bed'      ,'NaN',1,'size',[md.mesh.numberofvertices 1]);
			checkfield(md,'geometry.thickness','NaN',1,'size',[md.mesh.numberofvertices 1],'>',0);
			if any((obj.thickness-obj.surface+obj.bed)>10^-9),
				checkmessage(['equality thickness=surface-bed violated']);
			end 
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   geometry parameters:'));

			fielddisplay(obj,'surface','surface elevation');
			fielddisplay(obj,'thickness','ice thickness');
			fielddisplay(obj,'bed','bed elevation');
			fielddisplay(obj,'bathymetry','bathymetry elevation');
			fielddisplay(obj,'hydrostatic_ratio','coefficient for ice shelves'' thickness correction: hydrostatic_ratio H_obs+ (1-hydrostatic_ratio) H_hydro');

		end % }}}
	end
end
