function mds = modellist(varargin)
%MODEL - constructor for a list of models
%
%   Usage:
%      mds = modellist(varargin)

switch nargin

case 0

	% if no input arguments, create a default object
	mds.models=cell(0,1);

	%fields:
	mds.name='';
	mds.cluster='';
	mds.queue='';
	mds.time=0;
	mds.np=0;
	
	%output
	mds=class(mds,'modellist');

	%set default parameters
	mds=setdefaultparameters(mds);

case 1

	%If single argument of class model, we have a copy constructor. 
	if (isa(varargin{1},'modellist'))
		mds = varargin{1};
	elseif (isa(varargin{1},'cell'))
		celllist=varargin{1};
		
		%user gave us a list of models, plug them in mds.models, and do some set up
		mds=modellist;

		%check on size of cell list: 
		if (size(celllist,2)~=1),
			error('modellist constructor error message: list of models should be a cell list of column size 1');
		end

		%check that only models are in the celllist: 
		for i=1:size(celllist,1),
			md=celllist{i};
			if ~isa(md,'model')
				error(['modellist constructor error message: element ' num2str(i) ' of cell list is not a model!']);
			end
		end

		%initialize
		mds.models=celllist;

		%set some default parameters: 
		if size(celllist,1),
			%pick up 1st model for default parameters
			mds.cluster=mds.models{1}.cluster;
			mds.name=mds.models{1}.name;
			mds.queue=mds.models{1}.queue;
			mds.time=mds.models{1}.time;
		end
	else
		error('model constructor error message: copy constructor called on a non ''model'' class object');
	end 
otherwise
	error('model constructor error message: 0 of 1 argument only in input.');
end
