/*!\file DoubleExternalResult.c
 * \brief: implementation of the DoubleExternalResult object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*DoubleExternalResult constructors and destructor*/
/*FUNCTION DoubleExternalResult::DoubleExternalResult(){{{1*/
DoubleExternalResult::DoubleExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleExternalResult::DoubleExternalResult(int enum_type,double value){{{1*/
DoubleExternalResult::DoubleExternalResult(int in_id, int in_enum_type,double in_value,int in_step, double in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleExternalResult::~DoubleExternalResult(){{{1*/
DoubleExternalResult::~DoubleExternalResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleExternalResult::Echo {{{1*/
void DoubleExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleExternalResult::DeepEcho{{{1*/
void DoubleExternalResult::DeepEcho(void){

	printf("DoubleExternalResult:\n");
	printf("   id: %i\n",this->id);
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %g\n",this->value);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION DoubleExternalResult::Id{{{1*/
int    DoubleExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleExternalResult::MyRank{{{1*/
int    DoubleExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION DoubleExternalResult::Marshall{{{1*/
void  DoubleExternalResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleExternalResult: */
	enum_value=DoubleExternalResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleExternalResult data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleExternalResult::MarshallSize{{{1*/
int   DoubleExternalResult::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(id)
		+sizeof(enum_type)
		+sizeof(step)
		+sizeof(time)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleExternalResult::Demarshall{{{1*/
void  DoubleExternalResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION DoubleExternalResult::ObjectEnum{{{1*/
int DoubleExternalResult::ObjectEnum(void){

	return DoubleExternalResultEnum;

}
/*}}}*/
/*FUNCTION DoubleExternalResult::copy{{{1*/
Object* DoubleExternalResult::copy() {
	
	return new DoubleExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*DoubleExternalResult management: */
/*FUNCTION DoubleExternalResult::WriteData{{{1*/
void   DoubleExternalResult::WriteData(FILE* fid,bool io_gather){

	int     length;
	int     type;
	int     size;
	char   *name    = NULL;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	name=EnumToStringx(this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*writing a double, type is 1, size is 1: */
	type=1;
	size=1;
	fwrite(&type,sizeof(int),1,fid);
	fwrite(&size,sizeof(int),1,fid);
	fwrite(&this->value,size*sizeof(double),1,fid);

}
/*}}}1*/
/*FUNCTION DoubleExternalResult::GetResultName{{{1*/
char* DoubleExternalResult::GetResultName(void){
	return  EnumToStringx(this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleExternalResult::SetMatlabField{{{1*/
#ifdef _SERIAL_
void DoubleExternalResult::SetMatlabField(mxArray* dataref){

	char* name=NULL;
	name=this->GetResultName();
	mxSetField( dataref,this->step-1, name,mxCreateDoubleScalar(value));
	mxSetField( dataref, this->step-1, "time",mxCreateDoubleScalar((double)this->time)); 
	mxSetField( dataref, this->step-1, "step",mxCreateDoubleScalar((double)this->step)); 

}
#endif
/*}}}*/
/*FUNCTION DoubleExternalResult::GetStep{{{1*/
int DoubleExternalResult::GetStep(void){

	return this->step;
}
/*}}}*/
