/*!\file Reducevectorgtosx
 * \brief reduce petsc vector from g set to s set (single point constraints), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtosx.h"

void Reducevectorgtosx(Vec* pys, Vec yg, Nodes* nodes,Parameters* parameters){

	/*output: */
	Vec ys=NULL;

	/*variables: */
	int i;
	int configuration_type;
	int ssize;
	double* yg_serial=NULL;

	/*first figure out ssize: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	ssize=nodes->NumberOfDofs(configuration_type,SsetEnum);

	if(ssize==0){
		ys=NULL;
	}
	else{
		/*allocate: */
		ys=NewVec(ssize);

		if(nodes->NumberOfNodes(configuration_type)){ 

			/*serialize yg, so nodes can index into it: */
			VecToMPISerial(&yg_serial,yg);

			/*Go throygh all nodes, and ask them to retrieve values from yg, and plyg them into ys: */
			for(i=0;i<nodes->Size();i++){

				Node* node=(Node*)nodes->GetObjectByOffset(i);

				/*Check that this node corresponds to our analysis currently being carried out: */
				if (node->InAnalysis(configuration_type)){

					/*For this object, reduce values for enum set Fset: */
					node->VecReduce(ys,yg_serial,SsetEnum);
				}
			}
		}
		/*Assemble vector: */
		VecAssemblyBegin(ys);
		VecAssemblyEnd(ys);
	}

	/*Free ressources:*/
	xfree((void**)&yg_serial);

	/*Assign output pointers:*/
	*pys=ys;
}
