/*!\file Reducevectorgtofx
 * \brief reduce petsc vector from g set to s set (free dofs), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtofx.h"
 
void Reducevectorgtofx(Vec* puf, Vec ug, Nodes* nodes,Parameters* parameters){

	/*output: */
	Vec uf=NULL;

	/*variables: */
	int i;
	int configuration_type;
	int fsize;
	double* ug_serial=NULL;

	/*first figure out fsize: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	fsize=nodes->NumberOfDofs(configuration_type,FsetEnum);

	if(fsize==0){
		uf=NULL;
	}
	else{
		/*allocate: */
		uf=NewVec(fsize);

		if(nodes->NumberOfNodes(configuration_type)){ 

			/*serialize ug, so nodes can index into it: */
			VecToMPISerial(&ug_serial,ug);

			/*Go through all nodes, and ask them to retrieve values from ug, and plug them into uf: */
			for(i=0;i<nodes->Size();i++){

				Node* node=(Node*)nodes->GetObjectByOffset(i);

				/*Check that this node corresponds to our analysis currently being carried out: */
				if (node->InAnalysis(configuration_type)){

					/*For this object, reduce values for enum set Fset: */
					node->VecReduce(uf,ug_serial,FsetEnum);
				}
			}
		}
		/*Assemble vector: */
		VecAssemblyBegin(uf);
		VecAssemblyEnd(uf);
	}

	/*Free ressources:*/
	xfree((void**)&ug_serial);

	/*Assign output pointers:*/
	*puf=uf;
}
