/*!\file Reduceloadx
 * \brief reduce loads (wring out boundary conditions)
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Reduceloadx.h"
#include "../../io/io.h"

void	Reduceloadx( Vec pf, Mat Kfs, Vec y_s,bool flag_ys0){

	/*intermediary*/
	Vec         y_s0   = NULL;
	Vec         Kfsy_s = NULL;
	int         Kfsm,Kfsn;
	int         global_m,global_n;
	PetscScalar a;
	bool        fromlocalsize = true;
	int         verbose;

	_printf_(VerboseModule(),"   Dirichlet lifting applied to load vector\n");

	MatGetSize(Kfs,&global_m,&global_n);
	if(pf && global_m*global_n){

		/*Some checks in debugging mode*/
		_assert_(y_s);

		/*pf = pf - Kfs * y_s;*/
		MatGetLocalSize(Kfs,&Kfsm,&Kfsn);
		Kfsy_s=NewVec(Kfsm,fromlocalsize);
		if (flag_ys0){

			/*Create y_s0, full of 0: */
			VecDuplicate(y_s,&y_s0);
			VecSet(y_s0,0.0);
			VecAssemblyBegin(y_s0);
			VecAssemblyEnd(y_s0);

			MatMultPatch(Kfs,y_s0,Kfsy_s);
		}
		else{
			MatMultPatch(Kfs,y_s,Kfsy_s);
		}

		a=-1;
		VecAXPY(pf,a,Kfsy_s);  
	}


	/*Free ressources and return*/
	VecFree(&y_s0);
	VecFree(&Kfsy_s);

}
