#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#version of doxygen
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/oofem-//g'`

#Some cleanup
rm -rf src
rm -rf oofem-$version

#Create src and install directories
mkdir src

#Untar 
tar -zxvf  oofem-$version.tar.gz

#Move oofem into src directory
mv oofem-$version/* src
rm -rf oofem-$version

# currently a basic serial configuration, see http://www.oofem.org/wiki/doku.php?id=installation 
# for details on enabling the IML++ and PETSc libraries, and for configuring the parallel version
cd src && ./configure OOFEM_TARGET=oofem-$version --enable-dss && cd targets/oofem-$version

#Compile oofem 
if [ -z $NUMCPUS ];
then
	   make
		
	else
		make -j $NUMCPUS
fi

# build verification tools
cd ../../tools && make all

# testing solver
cd ../targets/oofem-$version && make tests && less ./test_results
