#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#version of netcdf
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/netcdf-//g'`

#Some cleanup
rm -rf install netcdf-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  netcdf-$version.tar.gz

#Move netcdf to install directory
rm -rf install/*
mv netcdf-$version/* install/
rm -rf netcdf-$version

#Configure netcdf
cd install
./configure  --prefix="$ISSM_TIER/externalpackages/netcdf/install" 

#Compile and install netcdf
if [ -z $NUMCPUS ];
then
	make
	make install
else
	make  -j $NUMCPUS
	make  -j $NUMCPUS install
fi
