#include <stdio.h>
using namespace std; 

void meshx(double* index,int n) {
	int i,j;
	for(int i=0;i<n;i++){
		printf("%g\n",index[i]);
	}
}

#include <boost/python.hpp>
#include <boost/python/module.hpp>
#include <boost/python/def.hpp>
using namespace boost::python;

void FetchData(double** array,int* N,boost::python::list pythonlist){/*{{{*/

	/*Get list size*/
	int n = boost::python::extract<int>(pythonlist.attr("__len__")());

	/*Assign double array and populate*/
	double* clist = new double[n];
	for (int i=0;i<n;i++) clist[i] = extract<double>(pythonlist[i]);

	/*Assign output pointers*/
	*array = clist;
	if(N) *N = n;
}/*}}}*/

void mesh(boost::python::list INDEX){
	double *index=NULL;
	int     n;

	FetchData(&index,&n,INDEX);

	/*Call x layer*/
	meshx(index,n);

	/*Clean up*/
	delete index;
}


#include <boost/python/module.hpp>
#include <boost/python/def.hpp>
using namespace boost::python;

BOOST_PYTHON_MODULE(TriMesh){
	def("mesh",mesh);
}
