#!/usr/bin/perl
#
#
# write a list of object filenames to an .rsp file,
# formatted according to tlib's input requirements
#
# usage:  rsp_formatter infile.rsp
# where:  infile.rsp is a one line file consisting of
#         object filenames
# output: is the tlib-formatted infile.rsp
# note:   multiple input files can be specified, e.g.
#         rsp_formatter infile1.rsp infile2.rsp -etc.-

use Fatal qw/ open /;
use File::Basename;
use Text::ParseWords;


foreach (@ARGV) {

#	loop (re)initialisation:
	@words = ();
	@new_words =();

	($name,$path,$suffix) = fileparse($_,"\.rsp");
	print "formatting $name$suffix for input to tlib...\n";

#	open, read explicitly so we can treat one ARGV at a time:
	open INFILE, "$_";
	$line=<INFILE>;
	close INFILE;
	chomp($line);

	@words = &parse_line('\s+', 0, $line);

	$i=0;
	foreach(@words) {
		if ($i < $#words) {
			push( @new_words, "+$_ &");
		}
		else {
			push( @new_words, "+$_,$name");
		}
		$i++;
	}

	open(OUTFILE, ">$_");
	foreach(@new_words) {
		print OUTFILE "$_\n";
	}
	close(OUTFILE); 

	print "...done\n";
}

