/*\file UpdateConstraints.c
 *\brief: build degrees of freedom for every node.
 */

#include "./UpdateConstraints.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes* nodes=NULL;
	Parameters* parameters=NULL;
	Constraints* constraints=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateConstraintsUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&nodes,NODESIN);
	FetchMatlabData((DataSet**)&constraints,CONSTRAINTS);
	FetchMatlabData(&parameters,PARAMETERS);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateConstraintsx(nodes,constraints,parameters);

	/*write output datasets: */
	WriteMatlabData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete constraints;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void UpdateConstraintsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [m.node]=%s(m.nodes,m.constraints,m.parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
