/*\file SpcNodes.c
 *\brief: build degrees of freedom for every node.
 */

#include "./SpcNodes.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes* nodes=NULL;
	Parameters* parameters=NULL;
	Constraints* constraints=NULL;
	int      analysis_type;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SpcNodesUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&nodes,NODESIN);
	FetchMatlabData((DataSet**)&constraints,CONSTRAINTS);
	FetchMatlabData(&parameters,PARAMETERS);
	FetchMatlabData(&analysis_type,ANALYSISTYPE);
	
	/*!Generate internal degree of freedom numbers: */
	SpcNodesx(nodes,constraints,parameters,analysis_type); 

	/*write output datasets: */
	WriteMatlabData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete constraints;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void SpcNodesUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [m.node]=%s(m.nodes,m.constraints,m.parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
