/*\file Response.c
 *\brief: compute response according to a response descriptor
 */

#include "./Response.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Loads      *loads      = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;
	char       *response   = NULL;
	bool        process_units;
	int         weight_index;

	/* output datasets: */
	double resp;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ResponseUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);
	FetchMatlabData(&response,RESPONSE);
	FetchMatlabData(&process_units,PROCESSUNITS);
	FetchMatlabData(&weight_index,WEIGHTINDEX);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	Responsex(&resp, elements,nodes,vertices, loads,materials,parameters,response,process_units,weight_index);

	/*write output : */
	WriteMatlabData(OUTPUT,resp);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&response);

	/*end module: */
	MODULEEND();
}

void ResponseUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [resp] = %s(elements,nodes,vertices,loads,materials,parameters,response,process_units);\n",__FUNCT__);
	_printf_(true,"\n");
	_printf_(true,"      response:      string ('MinVel', 'MassFlux', 'MaxAbsVx',...)\n");
	_printf_(true,"      process_units: bolean\n");
	_printf_(true,"\n");
}
