/*\file OutputRifts.c
 *\brief: output rift properties (fraction, penetration, etc ...)
 */

#include "./OutputRifts.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   numrifts;

	/*input datasets: */
	Loads* loads=NULL;

	/* output datasets: */
	Vec riftproperties=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&OutputRiftsUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData(&numrifts,mxGetField(PARAMETERS,0,"numrifts"));

	/*!Call core code: */
	OutputRiftsx(&riftproperties,loads,numrifts);

	/*write output : */
	WriteMatlabData(RIFTPROPERTIES,riftproperties);

	/*Free ressources: */
	delete loads;
	VecFree(&riftproperties);

	/*end module: */
	MODULEEND();
}

void OutputRiftsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [riftproperties] = %s(loads,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
