function S=netcdf2struct(File)
%NETCDF2STRUCT - load netcdf file and convert to a matlab structure
%
%   Usage:
%      S=netcdf2struct(File);

%Read netcdf file
data=netcdf(File);

%initialize output
S=struct();

%All the variables are in VarArray field
variables=data.VarArray;
for i=1:size(variables,2),
	fieldname=deblank(variables(i).Str);
	fieldvalue=double(squeeze(variables(i).Data));
	S.(fieldname)=fieldvalue;
end

%All the variables are in AttArray field
variables=data.AttArray;
for i=1:size(variables,2),
	fieldname=deblank(variables(i).Str);
	fieldvalue=double(variables(i).Val);
	S.(fieldname)=fieldvalue;
end
