function expsplit(domainoutline)
%EXPSPLIT - split exp file into sub-contours
%
%   This routine reads in a domain outline file (Argus format) and plots all the contours 
%   This will create as many files there are contours in the domain, each file will be postfix with _i
%   where i is the contour name. 
%
%   Usage:
%      expsplit(domainoutline)
%
%   Example:
%      expsplit('Domain.exp');
%
%   See also EXPMASTER, EXPDOC

%check nargin
if ~nargin | nargin>1
	help expsplit
	error('expsplit error message: bad usage');
end

[path,root,ext]=fileparts(domainoutline);

%Read file: 
domains=expread(domainoutline,1);

%split and write contours: 
for i=1:length(domains),
	subdomain=domains(i);
	expwrite(subdomain,[root '_' num2str(i)  ext]);
end
