function md=meshnodensity(md,domainname,varargin)
%MESH - create model mesh
%
%   This routine creates a model mesh using TriMeshNoDensity and a domain outline
%   where md is a @model object, domainname is the name of an Argus domain outline file, 
%   Riftname is an optional argument (Argus domain outline) describing rifts.
%   The  difference with mesh.m is that the resolution of the mesh follows that of the domain 
%   outline and the riftoutline
%
%   Usage:
%      md=setmesh(md,domainname)
%   or md=setmesh(md,domainname,riftname);
%
%   Examples:
%      md=setmesh(md,'DomainOutline.exp');
%      md=setmesh(md,'DomainOutline.exp','Rifts.exp');

if (nargin==2),
	riftname='';
end
if (nargin==3),
	riftname=varargin{1};
end

%Mesh using TriMeshNoDensity
if strcmp(riftname,''),
	[md.mesh.elements,md.mesh.x,md.mesh.y,md.mesh.segments,md.mesh.segmentmarkers]=TriMeshNoDensity(domainname);
else
	[elements,x,y,segments,segmentmarkers]=TriMeshNoDensity(domainname,riftname);

	%check that all the created nodes belong to at least one element
	orphan=find(~ismember([1:length(x)],sort(unique(elements(:)))));
	for i=1:length(orphan),
		%get rid of the orphan node i
		%update x and y
		x=[x(1:orphan(i)-(i-1)-1); x(orphan(i)-(i-1)+1:end)];
		y=[y(1:orphan(i)-(i-1)-1); y(orphan(i)-(i-1)+1:end)];
		%update elements
		pos=find(elements>orphan(i)-(i-1));
		elements(pos)=elements(pos)-1;
		%update segments
		pos1=find(segments(:,1)>orphan(i)-(i-1));
		pos2=find(segments(:,2)>orphan(i)-(i-1));
		segments(pos1,1)=segments(pos1,1)-1;
		segments(pos2,2)=segments(pos2,2)-1;
	end

	%plug into md
	md.mesh.x=x;
	md.mesh.y=y;
	md.mesh.elements=elements;
	md.mesh.segments=segments;
	md.mesh.segmentmarkers=segmentmarkers;
end

%Fill in rest of fields:
md.mesh.numberofelements=length(md.mesh.elements);
md.mesh.numberofvertices=length(md.mesh.x);
md.mesh.z=zeros(md.mesh.numberofvertices,1);
md.mesh.vertexonboundary=zeros(md.mesh.numberofvertices,1); md.mesh.vertexonboundary(md.mesh.segments(:,1:2))=1;
md.mesh.vertexonbed=ones(md.mesh.numberofvertices,1);
md.mesh.vertexonsurface=ones(md.mesh.numberofvertices,1);
md.mesh.elementonbed=ones(md.mesh.numberofelements,1);
md.mesh.elementonsurface=ones(md.mesh.numberofelements,1);

%Now, build the connectivity tables for this mesh.
md.mesh.vertexconnectivity=NodeConnectivity(md.mesh.elements,md.mesh.numberofvertices);
md.mesh.elementconnectivity=ElementConnectivity(md.mesh.elements,md.mesh.vertexconnectivity);

%type of model
md.mesh.dimension=2;
