function wb=basevert(md)
%BASEVERT - computes the basal vertical velcities
%
%   This routine computes the basal vertical velocities of ice shelves
%   for 2d models only using the following formula:
%   wb=rho_ice/rho_water*div(thickness*vel_horiz)+vel_horiz.grad(base)
%
%   Usage:
%      wb=basevert(md);

alpha=zeros(md.mesh.numberofelements,3);
beta=zeros(md.mesh.numberofelements,3);
gamma=zeros(md.mesh.numberofelements,3);

for n=1:md.mesh.numberofelements
	X=inv([md.mesh.x(md.mesh.elements(n,:)) md.mesh.y(md.mesh.elements(n,:)) ones(3,1)]);
	alpha(n,:)=X(1,:);
	beta(n,:)=X(2,:);
	gamma(n,:)=X(3,:);
end

hu=md.geometry.thickness.*md.initialization.vx;
hv=md.geometry.thickness.*md.initialization.vy;

summation=[1;1;1];
hux=(hu(md.mesh.elements).*alpha)*summation;
hvy=(hv(md.mesh.elements).*beta)*summation;

uelem=md.initialization.vx(md.mesh.elements)*summation/3;
velem=md.initialization.vy(md.mesh.elements)*summation/3;

dbdx=(md.geometry.bed(md.mesh.elements).*alpha)*summation;
dbdy=(md.geometry.bed(md.mesh.elements).*beta)*summation;

wb=-md.materials.rho_ice/md.materials.rho_water*(hux+hvy)+uelem.*dbdx+velem.*dbdy;
